/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Adc_Filter.h
\brief      This file contains all Configuration parameters of ADC Filter driver
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       11/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#ifndef __ADC_FLTR_H__
 #define __ADC_FLTR_H__
   
   #include "Adc.h"
   #include "Adc_Filter_ReportError.h"
   #include "Adc_Fltr_Cfg.h"
   
   /* Defines the config structure used for in channel */
typedef struct
{
  uint16_t numTAPS:6;  /* Number of taps used by this driver */
  uint16_t numChannels:4;  /* Number of channels managed by this driver */
  uint16_t interruptCPU:1;      /* TRUE if CPU should be interrupted at end of thread */
} tAdcFltr_ChannelConfig;

/* Defines the structure used for each channel */
typedef struct
{
  uint16_t* pSampleBuffer;    /* Pointer to the stored ATD samples         */
  uint16_t* pResultRegister;  /* Pointer to the ATD results register       */
  uint16_t*	pFilterResult;    /* Pointer to the latest filter output value */
  void (*FltrEndNotification)(void); /* Filter End Function Notification   */	
} tAdcFltr_ChannelStruct;

/* Defines the structure used for each ATD */
typedef struct
{
  tAdcFltr_ChannelStruct* channels; /* Array of channelstructs */
  tAdcFltr_ChannelConfig config;
} tAdcFltr_FilterStruct;

extern tAdcFltr_FilterStruct sATD0;
/* Function prototypes */
void xl_atd_Average(tAdcFltr_FilterStruct* filter);
void xl_atd_initaverage();
void vfnADC_Start_Average(void);
void vfnADC_Stop_Average(void);

   /*------------- Function Prototypes ---------------------------------------------------*/
   extern void vfnAdc_Collect_Results(void);
   
 #endif
 